import 'dart:convert';

/// Recomended : [{"id":4,"tmdb_id":791373,"title":"Zack Snyder's Justice League","slug":"zack-snyders-justice-league","keyword":"superhero,dc comics,based on comic, superhero team,Action,Fantasy,Science Fiction","description":"Determined to ensure Superman's ultimate sacrifice was not in vain, Bruce Wayne aligns forces with Diana Prince with plans to recruit a team of metahumans to protect the world from an approaching threat of catastrophic proportions.","duration":"242","thumbnail":"tmdb_tnAuB8q5vv7Ax9UAEje5Xi4BXik.jpg","poster":"poster_pcDc2WJAYGJTTvRSEIpRZwM3Ola.jpg","tmdb":"Y","fetch_by":"title","director_id":"724,725,726,727,728,729,730,731","actor_id":"725,726,727,728,729","genre_id":"1,2,6,10","trailer_url":"https://youtu.be/xu8SB_xte9M","detail":"Determined to ensure Superman's ultimate sacrifice was not in vain, Bruce Wayne aligns forces with Diana Prince with plans to recruit a team of metahumans to protect the world from an approaching threat of catastrophic proportions.","views":0,"rating":8.2,"maturity_rating":"all age","subtitle":0,"publish_year":2021,"released":"2021-03-18","upload_video":null,"featured":0,"series":0,"a_language":"1","audio_files":null,"type":"M","live":0,"livetvicon":null,"status":1,"is_protect":0,"password":"eyJpdiI6IlhDU3M1VlZOeTkxdFZDZDBIT3BqOFE9PSIsInZhbHVlIjoiV3dXN1puV25JQzVBV3U1dFp5U2o2UT09IiwibWFjIjoiZmJiOTY0MmRiZDg0MDMwZmIyM2NmZjBlYzA5YWFkZGI4NGUwOGE4MjA3YjZmNGFhZDAyYWIyNzM5ZWEwYjgwNCIsInRhZyI6IiJ9","created_by":1,"created_at":"2021-08-03T16:22:28.000000Z","updated_at":"2022-12-03T07:00:36.000000Z","is_upcoming":0,"is_custom_label":0,"label_id":null,"upcoming_date":null,"is_kids":0,"country":0,"is_custom_thumb":0,"user-rating":0},{"id":5,"tmdb_id":635302,"title":"Demon Slayer -Kimetsu no Yaiba- The Movie: Mugen Train","slug":"demon-slayer-kimetsu-no-yaiba-the-movie-mugen-train","keyword":"Animation, Actio, Adventure,Fantasy,magic, psychology","description":"Tanjirō Kamado, joined with Inosuke Hashibira, a boy raised by boars who wears a boar's head, and Zenitsu Agatsuma, a scared boy who reveals his true power when he sleeps, boards the Infinity Train on a new mission with the Fire Hashira, Kyōjurō Rengoku, to defeat a demon who has been tormenting the people and killing the demon slayers who oppose it!","duration":"117","thumbnail":"tmdb_h8Rb9gBr48ODIwYUttZNYeMWeUU.jpg","poster":"poster_qjGrUmKW78MCFG8PTLDBp67S27p.jpg","tmdb":"Y","fetch_by":"title","director_id":"715,716,717,718,719,720,721,722,723","actor_id":"720,721,722,723,724","genre_id":"12,1,2,6","trailer_url":"https://youtu.be/XbTSLJ62YEM","detail":"Tanjirō Kamado, joined with Inosuke Hashibira, a boy raised by boars who wears a boar's head, and Zenitsu Agatsuma, a scared boy who reveals his true power when he sleeps, boards the Infinity Train on a new mission with the Fire Hashira, Kyōjurō Rengoku, to defeat a demon who has been tormenting the people and killing the demon slayers who oppose it!","views":0,"rating":8.31,"maturity_rating":"all age","subtitle":1,"publish_year":2020,"released":"2020-10-16","upload_video":null,"featured":0,"series":0,"a_language":"1","audio_files":null,"type":"M","live":0,"livetvicon":null,"status":1,"is_protect":0,"password":"eyJpdiI6IkYzQ0dsNXIwQkQwMndYWWZta1ZtYlE9PSIsInZhbHVlIjoiMlQwSzBNKytpNi95U29maG0rdktMZz09IiwibWFjIjoiZDBlNzcyNTEwZjQwOTM4ZWU4N2Q0N2I2MjEzMWViNTgwYTQyMmQ2NTUxMWI5N2RlMzc3ZjQ1YTNhZWM0YzAzZCIsInRhZyI6IiJ9","created_by":27,"created_at":"2021-08-03T16:32:34.000000Z","updated_at":"2022-12-03T06:58:41.000000Z","is_upcoming":0,"is_custom_label":0,"label_id":null,"upcoming_date":null,"is_kids":0,"country":0,"is_custom_thumb":0,"user-rating":0},{"id":11,"tmdb_id":801335,"title":"Girl in the Basement","slug":"girl-in-the-basement","keyword":"Crime,Thriller","description":"Sara is a teen girl who is looking forward to her 18th birthday to move away from her controlling father Don. But before she could even blow out the candles, Don imprisons her in the basement of their home.","duration":"88","thumbnail":"tmdb_qmddUxRwbsxHa7oEXm4PWh1KZe8.jpg","poster":"poster_fvUmnxS9xaUUl0eWygvcA1hPdTV.jpg","tmdb":"Y","fetch_by":"title","director_id":"713","actor_id":"710,711,712,713,714","genre_id":"5,13,18","trailer_url":"https://youtu.be/a7VGn_0Vsx8","detail":"Sara is a teen girl who is looking forward to her 18th birthday to move away from her controlling father Don. But before she could even blow out the candles, Don imprisons her in the basement of their home.","views":0,"rating":7.96,"maturity_rating":"all age","subtitle":0,"publish_year":2021,"released":"2021-02-27","upload_video":null,"featured":0,"series":0,"a_language":"2","audio_files":null,"type":"M","live":0,"livetvicon":null,"status":1,"is_protect":0,"password":"eyJpdiI6IlhhT2IrMHhKdWdWeHN6M1kzZ3NqN2c9PSIsInZhbHVlIjoiRndTb1crRi9vQkRiVDBVSFlXeXRmZz09IiwibWFjIjoiZDMzMTdkMWQxZmRlM2IwYjlmZWE4MTAyMzFkMTVmODhhMjViN2ZkNmY2NDhjYTEwYmQ5NDdlMjczMDcyMzM3ZSIsInRhZyI6IiJ9","created_by":1,"created_at":"2021-08-03T17:23:53.000000Z","updated_at":"2022-12-03T06:52:06.000000Z","is_upcoming":0,"is_custom_label":0,"label_id":null,"upcoming_date":null,"is_kids":0,"country":0,"is_custom_thumb":0,"user-rating":0},{"id":19,"tmdb_id":784500,"title":"Pretty Guardian Sailor Moon Eternal The Movie Part 2","slug":"pretty-guardian-sailor-moon-eternal-the-movie-part-2","keyword":"Animation,Action,Comedy, Fantasy,Romance, Adventure","description":"While under the care of the Outer Sailor Guardians, Hotaru begins to age rapidly. Then, the time comes for all the Sailor Guardians to reunite!","duration":"80","thumbnail":"tmdb_f91rtk8dODezNLT3grQrELyzFwA.jpg","poster":"poster_4QA7pKpmNgeXkhN1FFIBelHwr6V.jpg","tmdb":"Y","fetch_by":"title","director_id":"601,602,603,604,605","actor_id":"645,646,647,648,649","genre_id":"12,1,2,3,11,6,9","trailer_url":"https://youtu.be/XDnKDYpvEgo","detail":"While under the care of the Outer Sailor Guardians, Hotaru begins to age rapidly. Then, the time comes for all the Sailor Guardians to reunite!","views":0,"rating":8.09,"maturity_rating":"all age","subtitle":0,"publish_year":2021,"released":"2021-02-11","upload_video":null,"featured":0,"series":0,"a_language":"2","audio_files":null,"type":"M","live":0,"livetvicon":null,"status":1,"is_protect":0,"password":"eyJpdiI6ImVrR1lRcHBxcURmRDFvelZva2d1aXc9PSIsInZhbHVlIjoiZFNMYnNXeFFmQzJ1YjBxMlNqUFd3QT09IiwibWFjIjoiZWM3OWQwMzliNDAyYzRiMzEyMDA2MWI0ODFiMmMzOTdiMjVkZDRjYjgwODI5MzI4NGY3MTI1NjIyYjNlNjRmMSIsInRhZyI6IiJ9","created_by":1,"created_at":"2021-08-04T15:36:13.000000Z","updated_at":"2022-12-02T06:29:05.000000Z","is_upcoming":0,"is_custom_label":0,"label_id":null,"upcoming_date":null,"is_kids":0,"country":0,"is_custom_thumb":0,"user-rating":0}]

RecommendedDataModel recommendedDataModelFromJson(String str) =>
    RecommendedDataModel.fromJson(json.decode(str));
String recommendedDataModelToJson(RecommendedDataModel data) =>
    json.encode(data.toJson());

class RecommendedDataModel {
  RecommendedDataModel({
    this.recomended,
  });

  RecommendedDataModel.fromJson(dynamic json) {
    if (json['Recomended'] != null) {
      recomended = [];
      json['Recomended'].forEach((v) {
        recomended?.add(Recomended.fromJson(v));
      });
    }
  }
  List<Recomended>? recomended;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (recomended != null) {
      map['Recomended'] = recomended?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

/// id : 4
/// tmdb_id : 791373
/// title : "Zack Snyder's Justice League"
/// slug : "zack-snyders-justice-league"
/// keyword : "superhero,dc comics,based on comic, superhero team,Action,Fantasy,Science Fiction"
/// description : "Determined to ensure Superman's ultimate sacrifice was not in vain, Bruce Wayne aligns forces with Diana Prince with plans to recruit a team of metahumans to protect the world from an approaching threat of catastrophic proportions."
/// duration : "242"
/// thumbnail : "tmdb_tnAuB8q5vv7Ax9UAEje5Xi4BXik.jpg"
/// poster : "poster_pcDc2WJAYGJTTvRSEIpRZwM3Ola.jpg"
/// tmdb : "Y"
/// fetch_by : "title"
/// director_id : "724,725,726,727,728,729,730,731"
/// actor_id : "725,726,727,728,729"
/// genre_id : "1,2,6,10"
/// trailer_url : "https://youtu.be/xu8SB_xte9M"
/// detail : "Determined to ensure Superman's ultimate sacrifice was not in vain, Bruce Wayne aligns forces with Diana Prince with plans to recruit a team of metahumans to protect the world from an approaching threat of catastrophic proportions."
/// views : 0
/// rating : 8.2
/// maturity_rating : "all age"
/// subtitle : 0
/// publish_year : 2021
/// released : "2021-03-18"
/// upload_video : null
/// featured : 0
/// series : 0
/// a_language : "1"
/// audio_files : null
/// type : "M"
/// live : 0
/// livetvicon : null
/// status : 1
/// is_protect : 0
/// password : "eyJpdiI6IlhDU3M1VlZOeTkxdFZDZDBIT3BqOFE9PSIsInZhbHVlIjoiV3dXN1puV25JQzVBV3U1dFp5U2o2UT09IiwibWFjIjoiZmJiOTY0MmRiZDg0MDMwZmIyM2NmZjBlYzA5YWFkZGI4NGUwOGE4MjA3YjZmNGFhZDAyYWIyNzM5ZWEwYjgwNCIsInRhZyI6IiJ9"
/// created_by : 1
/// created_at : "2021-08-03T16:22:28.000000Z"
/// updated_at : "2022-12-03T07:00:36.000000Z"
/// is_upcoming : 0
/// is_custom_label : 0
/// label_id : null
/// upcoming_date : null
/// is_kids : 0
/// country : 0
/// is_custom_thumb : 0
/// user-rating : 0

Recomended recomendedFromJson(String str) =>
    Recomended.fromJson(json.decode(str));
String recomendedToJson(Recomended data) => json.encode(data.toJson());

class Recomended {
  Recomended({
    this.id,
    this.tmdbId,
    this.title,
    this.slug,
    this.keyword,
    this.description,
    this.duration,
    this.thumbnail,
    this.poster,
    this.tmdb,
    this.fetchBy,
    this.directorId,
    this.actorId,
    this.genreId,
    this.trailerUrl,
    this.detail,
    this.views,
    this.rating,
    this.maturityRating,
    this.subtitle,
    this.publishYear,
    this.released,
    this.uploadVideo,
    this.featured,
    this.series,
    this.aLanguage,
    this.audioFiles,
    this.type,
    this.live,
    this.livetvicon,
    this.status,
    this.isProtect,
    this.password,
    this.createdBy,
    this.createdAt,
    this.updatedAt,
    this.isUpcoming,
    this.isCustomLabel,
    this.labelId,
    this.upcomingDate,
    this.isKids,
    this.country,
    this.isCustomThumb,
    this.userrating,
  });

  Recomended.fromJson(dynamic json) {
    id = num.tryParse(json['id'].toString());
    tmdbId = num.tryParse(json['tmdb_id'].toString());
    title = json['title'];
    slug = json['slug'];
    keyword = json['keyword'];
    description = json['description'];
    duration = json['duration'];
    thumbnail = json['thumbnail'];
    poster = json['poster'];
    tmdb = json['tmdb'];
    fetchBy = json['fetch_by'];
    directorId = json['director_id'];
    actorId = json['actor_id'];
    genreId = json['genre_id'];
    trailerUrl = json['trailer_url'];
    detail = json['detail'];
    views = num.tryParse(json['views'].toString());
    rating = num.tryParse(json['rating'].toString());
    maturityRating = json['maturity_rating'];
    subtitle = num.tryParse(json['subtitle'].toString());
    publishYear = num.tryParse(json['publish_year'].toString());
    released = json['released'];
    uploadVideo = json['upload_video'];
    featured = num.tryParse(json['featured'].toString());
    series = num.tryParse(json['series'].toString());
    aLanguage = json['a_language'];
    audioFiles = json['audio_files'];
    type = json['type'];
    live = num.tryParse(json['live'].toString());
    livetvicon = json['livetvicon'];
    status = num.tryParse(json['status'].toString());
    isProtect = num.tryParse(json['is_protect'].toString());
    password = json['password'];
    createdBy = num.tryParse(json['created_by'].toString());
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    isUpcoming = num.tryParse(json['is_upcoming'].toString());
    isCustomLabel = num.tryParse(json['is_custom_label'].toString());
    labelId = json['label_id'];
    upcomingDate = json['upcoming_date'];
    isKids = num.tryParse(json['is_kids'].toString());
    country = num.tryParse(json['country'].toString());
    isCustomThumb = num.tryParse(json['is_custom_thumb'].toString());
    userrating = num.tryParse(json['user-rating'].toString());
  }
  num? id;
  num? tmdbId;
  String? title;
  String? slug;
  String? keyword;
  String? description;
  String? duration;
  String? thumbnail;
  String? poster;
  String? tmdb;
  String? fetchBy;
  String? directorId;
  String? actorId;
  String? genreId;
  String? trailerUrl;
  String? detail;
  num? views;
  num? rating;
  String? maturityRating;
  num? subtitle;
  num? publishYear;
  String? released;
  dynamic uploadVideo;
  num? featured;
  num? series;
  String? aLanguage;
  dynamic audioFiles;
  String? type;
  num? live;
  dynamic livetvicon;
  num? status;
  num? isProtect;
  String? password;
  num? createdBy;
  String? createdAt;
  String? updatedAt;
  num? isUpcoming;
  num? isCustomLabel;
  dynamic labelId;
  dynamic upcomingDate;
  num? isKids;
  num? country;
  num? isCustomThumb;
  num? userrating;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['tmdb_id'] = tmdbId;
    map['title'] = title;
    map['slug'] = slug;
    map['keyword'] = keyword;
    map['description'] = description;
    map['duration'] = duration;
    map['thumbnail'] = thumbnail;
    map['poster'] = poster;
    map['tmdb'] = tmdb;
    map['fetch_by'] = fetchBy;
    map['director_id'] = directorId;
    map['actor_id'] = actorId;
    map['genre_id'] = genreId;
    map['trailer_url'] = trailerUrl;
    map['detail'] = detail;
    map['views'] = views;
    map['rating'] = rating;
    map['maturity_rating'] = maturityRating;
    map['subtitle'] = subtitle;
    map['publish_year'] = publishYear;
    map['released'] = released;
    map['upload_video'] = uploadVideo;
    map['featured'] = featured;
    map['series'] = series;
    map['a_language'] = aLanguage;
    map['audio_files'] = audioFiles;
    map['type'] = type;
    map['live'] = live;
    map['livetvicon'] = livetvicon;
    map['status'] = status;
    map['is_protect'] = isProtect;
    map['password'] = password;
    map['created_by'] = createdBy;
    map['created_at'] = createdAt;
    map['updated_at'] = updatedAt;
    map['is_upcoming'] = isUpcoming;
    map['is_custom_label'] = isCustomLabel;
    map['label_id'] = labelId;
    map['upcoming_date'] = upcomingDate;
    map['is_kids'] = isKids;
    map['country'] = country;
    map['is_custom_thumb'] = isCustomThumb;
    map['user-rating'] = userrating;
    return map;
  }
}
